%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Matt Fitzgerald
% plot function for Fuzzy Pareto Shift distributions

% INPUTS
%   FPS - (design,epoch) matrix of fuzzy pareto shift scores
%   designList - row vector of design numbers to plot

% NOTE: MAXES OUT AT 28 DESIGNS (not that more than 10 is even legible)

function h = FPSdistrPlot(FPS,designList)

% reduce full size
FPSreduc = FPS(designList,:);

% find range
minRange = min(min(FPSreduc));
maxRange = max(max(FPSreduc));

% make bins
edges = minRange:maxRange;

% make histograms
for design = 1:length(designList)
    H(:,design) = histc(FPSreduc(design,:),[edges inf]);
end

% color and style list for for-loop plotting
Colors = {'red','green','blue','yellow','black','cyan','magenta'};
Styles = {'-','--','-.',':'};

% plot
xpoints = [edges maxRange+1];
h = figure();
hold on
for i = 1:length(designList)
    idx1 = mod(i-1,length(Colors)) + 1;
    idx2 = (i - idx1)/length(Colors) + 1;
    plot(xpoints,H(:,i),'LineWidth',2,'Color',Colors{idx1},'LineStyle',Styles{idx2})
end
title('Design Valuable Changeability Frequencies')
xlabel('Fuzzy Pareto Shift')
ylabel('# of epochs')
legend(num2str(designList'),'Location','NorthEast')
hold off


end